/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import java.util.function.Consumer;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.text.ITextCollection;
import team.creative.creativecore.common.util.text.TextListBuilder;

public class GuiTabButton
extends GuiParent {
    public static final ControlFormatting BUTTON_ACTIVE = new ControlFormatting(ControlFormatting.ControlStyleBorder.SMALL, 2, ControlFormatting.ControlStyleFace.CLICKABLE);
    public static final ControlFormatting BUTTON_INACTIVE = new ControlFormatting(ControlFormatting.ControlStyleBorder.SMALL, 2, ControlFormatting.ControlStyleFace.CLICKABLE_INACTIVE);
    private int index = 0;
    public GuiBorderlessButton selected;

    public GuiTabButton(String name, ITextCollection states) {
        this(name, 0, states);
    }

    public GuiTabButton(String name, int index, ITextCollection states) {
        super(name, null);
        this.flow = GuiFlow.STACK_X;
        int i = 0;
        for (CompiledText text : states.build()) {
            int bIndex = i;
            this.add((GuiControl)new GuiBorderlessButton("b" + i, x -> this.select(bIndex)).setText(text));
            ++i;
        }
        this.select(index);
    }

    public GuiTabButton(String name, int index, String ... states) {
        this(name, index, new TextListBuilder().add(states));
    }

    public void select(int index) {
        this.index = index;
        if (this.selected != null) {
            this.selected.active = false;
        }
        this.selected = (GuiBorderlessButton)((GuiChildControl)this.controls.get((int)index)).control;
        this.selected.active = true;
        this.raiseEvent(new GuiControlChangedEvent<GuiTabButton>(this));
    }

    public int index() {
        return this.index;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }

    public static class GuiBorderlessButton
    extends GuiButton {
        public boolean active = false;

        public GuiBorderlessButton(String name, Consumer<Integer> pressed) {
            super(name, pressed);
        }

        @Override
        public ControlFormatting getControlFormatting() {
            if (this.active) {
                return BUTTON_ACTIVE;
            }
            return BUTTON_INACTIVE;
        }
    }
}

